// -----------------------------------------------------------------------------------------
//                      L I G H T S
//------------------------------------------------------------------------------------------ 

#declare array_count = 12    ;

#declare light_above =
light_source {
    <0,0,0> 
    #declare light_color = color red .05 green .05 blue .05 ;                      
    light_color * 50                  
    area_light
    <50, 0, 0> <0, 0, 10>         
    array_count, array_count                          
    adaptive 1                    
    jitter                        
    circular                      
    orient                     
    fade_distance 50
    fade_power 2     
    translate <10, 800, -300>
}   
light_above




#declare light_head =
light_source {
    <0,0,0> 
    #declare light_color = color red .05 green .05 blue .05 ;                      
    light_color * 100                  
    area_light
    <50, 0, 0> <0, 0, 10>         
    array_count, array_count                          
    adaptive 1                    
    jitter                        
    circular                      
    orient                     
    fade_distance 30
    fade_power 2     
    translate <10, 600, -100>
}   
light_head




#declare light_behide =
light_source {
    <0,0,0> 
    #declare light_color = color red .06 green .06 blue .05 ;                      
    light_color * 70                  
    area_light
    <50, 0, 0> <0, 0, 50>         
    array_count, array_count                          
    adaptive 0                    
    jitter                        
    circular                      
    orient                     
    fade_distance 300
    fade_power 2     
    translate <800,800,-1500>
}   
light_behide


// --- under
#declare light_U =
light_source {
    <0,0,0> 
    #declare light_color = color red .06 green .05 blue .04 ;                      
    light_color * 15                  
    area_light
    <300, 0, 0> <0, 0, 100>         
    array_count, array_count                          
    adaptive 0                    
    jitter                        
    circular                      
    orient                     
    fade_distance 80
    fade_power 2     
    translate <100, -100, -100> 
    shadowless 
}   
light_U


// -----------------------------------------------------------------------------------------
//                      C A M E R A S
//------------------------------------------------------------------------------------------ s

#macro render_plan(f, nx, nz)
    camera {
        up <0, 1, 0>
        angle f    
        location <0, 50000, 0>
        look_at <0 , 0 ,  0> 
        translate <nx,0,nz>
    } 
#end 

#macro render_front_elev(f, nx, ny)
    camera {
        up <0, 1, 0>
        angle f    
        location <0, 40, -100000>
        look_at <0 , 0 ,  0> 
        translate <nx,ny,0>
    } 
#end 
 
 
#macro render_side_elev(f, nx, ny)
    camera {
        up <0, 1, 0>
        angle f    
        location <-100000, 0, 0>
        look_at <0 , 0 ,  0> 
        translate <nx,ny,0>
    } 
#end 


#macro render_ceiling(f, nx, ny)
    camera {
        up <0, 1, 0>
        angle f    
        location <0, -5000, 0>
        look_at <0 , 0 ,  0> 
        translate <nx,ny,0>
    } 
#end 



#macro render_top_left(f, pos)
    camera {
        up <0, 1, 0>
        angle f    
        location <0, 200, -200> 
        look_at pos
    } 
#end 


#macro render_bottom_left(f, pos)
    camera {
        up <0, 1, 0>
        angle f    
        location <-50, -50, -50> 
        look_at pos
    } 
#end 



#macro render_top_right(f, pos)
    camera {
        up <0, 1, 0>
        angle f    
        location <100, 50, -50> 
        look_at pos
    } 
#end   


#macro render_bottom_right(f, pos)
    camera {
        up <0, 1, 0>
        angle f    
        location <50, -50, -50> 
        look_at pos
    } 
#end        

#macro render_ground_left(f, pos)
    camera {
        up <0, 1, 0>
        angle f    
        location <-20, 10, -250> 
        look_at pos
    } 
#end       



#macro render_view_A(f, pos)
    camera {
        up <0, 1, 0>
        angle f    
        location <-60, 50, -210> 
        look_at pos
    } 
#end  


#macro render_view_B(f, pos)
    camera {
        up <0, 1, 0>
        angle f    
        location <-80, 55, -90> 
        look_at pos
    } 
#end  

#macro render_view_C(f, pos)
    camera {
        up <0, 1, 0>
        angle f    
        location <250, 380, -400> 
        look_at pos
    } 
#end  

#macro render_view_D(f, pos)
    camera {
        up <0, 1, 0>
        angle f    
        location <-250, 400, -1000> 
        look_at pos
    } 
#end  
           
           
#macro view_zero(f, pos)
    camera {
        up <0, 1, 0>  
            right x*image_width/image_height
        angle f    
        location <0,300, -100> 
        look_at pos
    } 
#end 


#macro render_view_E(f, pos)
    camera {
        up <0, 1, 0>
        angle f    
        location <200, 380, -400> 
        look_at pos
    } 
#end   




#macro render_breaker(f, pos)
    camera {
        up <0, 1, 0>
        angle f    
        location <-200, 320, -400> 
        look_at pos
    } 
#end     


#macro render_view_pegboard(f, pos)
    camera {
        up <0, 1, 0>
        angle f    
        location <-150, 440, -400> 
        look_at pos
    } 
#end  




    



#macro render_final(f, pos)
    camera {
        up <0, 1, 0>
        right x*image_width/image_height
        angle f    
        location <250, 380, -430> 
        look_at pos
    } 
#end  